<?php

namespace App\Models\Events;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EventFacts extends Model 
{

    protected $table = 'event_facts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('age0', 'public_registration');

    public function getRealizations()
    {
        return $this->hasMany('EventRealization');
    }

    public function getInstitution()
    {
        return $this->belongsTo('Institution');
    }

    public function getUser()
    {
        return $this->belongsTo('User');
    }

    public function getAccreditation()
    {
        return $this->hasOne('Accreditation');
    }

    public function getScopeRating()
    {
        return $this->belongsTo('ScopeRating');
    }

    public function getKeywords()
    {
        return $this->belongsToMany('Keyword', 'action_facts_keyword');
    }

    public function getEpisodeType()
    {
        return $this->belongsTo('EpisodeType');
    }

    public function getInvolvements()
    {
        return $this->belongsToMany('Involvement', 'event_facts_involvement');
    }

    public function getQuiz()
    {
        return $this->hasOne('EventFacts');
    }

}